<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:strip-space elements="*"/>
    <!-- ASCII Profile Station Elevation Report (from Station Offset Points) -->
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads">
                    <xsl:text/>
                    <xsl:text>* Výpis Profil Staničení Odstup Výška (z bodů Staničení Odstup)&#xd;</xsl:text>
                    <xsl:text>* Datum výpisu: </xsl:text><xsl:value-of select="cif:date()"/><xsl:text>&#xd;</xsl:text>
                    <!-- Project Data -->
                    <xsl:for-each select="GeometryProject">
                        <xsl:text>* Projekt: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* Název souboru: </xsl:text><xsl:value-of select="@file"/><xsl:text>&#xd;</xsl:text>
                        <!-- Horizontal Alignment Data -->
                        <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                            <xsl:text>*&#xd;</xsl:text>
                            <xsl:text>* Trasa Název: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                            <xsl:text>*&#xd;</xsl:text>
                            <xsl:text>*      Staničení        Odstup        Z    &#xd;</xsl:text>
                            <xsl:text>*&#xd;</xsl:text>
                            <!-- Station Offset Point Data -->
                            <xsl:for-each select="StationOffsetPoints/StationOffsetPoint">
                                <xsl:variable name="fmtStation" select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                <xsl:if test="not (@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                                    <xsl:text>* Odstup (Definovaný) Trasa:  </xsl:text><xsl:value-of select="@offsetAlignmentName"/><xsl:text>&#xd;</xsl:text>
                                </xsl:if>
                                <xsl:value-of select="cif:columnFormat(string($fmtStation),14)"/>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@firstOffset),14)"/>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@existingGroundElevation), 17)"/>
                                <xsl:text>&#xd;</xsl:text>
                            </xsl:for-each>
                            <xsl:text>&#xd;</xsl:text>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>    Pro tento výpis musíte vytvořit body ve staničení a odstupu&#xd;</xsl:text>
        <xsl:text>    buď pomocí Nástroje &gt; XML Výpisy &gt; Základní staničení&#xd;</xsl:text>
        <xsl:text>    nebo Nástroje &gt; XML Výpisy &gt; Staničení Odstup.&#xd;&#xd;</xsl:text>
        <xsl:text>    Musíte vybrat nejméně jedno směrové řešení &#xd;</xsl:text>
        <xsl:text>    nebo jeden prvek v listu Obecně v poli Z&#xd;&#xd;</xsl:text>
        <xsl:text>    Musíte také vybrat stejné směrové řešení v listu Směrová řešení nebo prvek v listu Prvky.&#xd;</xsl:text>
        <xsl:text>    Musíte vybrat nejméně jednu volbu v listu Zahrnout (Směrové body - Na trase, Významné,&#xd;</xsl:text>
        <xsl:text>    Výškové body - Na trase, Významné&#xd;</xsl:text>
        <xsl:text>    nebo Interval)&#xd;&#xd;</xsl:text>
        <xsl:text>    Staničení Limity použijte pouze na spočtená data, např. body pomocí Interval.&#xd;</xsl:text>
        <xsl:text>    Většina formulářů ve složce DataCollection &#xd;</xsl:text>
        <xsl:text>   nepodporuje Nástroje &gt; Možnosti formátu, s výjimkou &#xd;</xsl:text>
        <xsl:text>    přesnosti tam, kde je to vhodné.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2006 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
